/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.networking;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions;
import net.fabricmc.fabric.impl.networking.PacketCallbackListener;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.protocol.Packet;
import org.sinytra.fabric.networking_api.NeoListenableNetworkHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
abstract class ClientConnectionMixin {
    @Shadow
    private PacketListener packetListener;

    ClientConnectionMixin() {
    }

    @Inject(method={"sendPacket"}, at={@At(value="FIELD", target="Lnet/minecraft/network/Connection;sentPackets:I")})
    private void checkPacket(Packet<?> packet, ChannelFutureListener callback, boolean flush, CallbackInfo ci) {
        if (this.packetListener instanceof PacketCallbackListener) {
            ((PacketCallbackListener)this.packetListener).sent(packet);
        }
    }

    @Inject(method={"validateListener"}, at={@At(value="HEAD")})
    private void unwatchAddon(ProtocolInfo<?> state, PacketListener listener, CallbackInfo ci) {
        PacketListener packetListener = this.packetListener;
        if (packetListener instanceof NetworkHandlerExtensions) {
            NetworkHandlerExtensions oldListener = (NetworkHandlerExtensions)packetListener;
            oldListener.getAddon().endSession();
        }
    }

    @Inject(method={"channelInactive"}, at={@At(value="HEAD")})
    private void disconnectAddon(ChannelHandlerContext channelHandlerContext, CallbackInfo ci) {
        PacketListener packetListener = this.packetListener;
        if (packetListener instanceof NetworkHandlerExtensions) {
            NetworkHandlerExtensions extension = (NetworkHandlerExtensions)packetListener;
            extension.getAddon().handleDisconnect();
        }
    }

    @Inject(method={"handleDisconnection"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/PacketListener;onDisconnect(Lnet/minecraft/network/DisconnectionDetails;)V")})
    private void disconnectAddon(CallbackInfo ci) {
        PacketListener packetListener = this.packetListener;
        if (packetListener instanceof NetworkHandlerExtensions) {
            NetworkHandlerExtensions extension = (NetworkHandlerExtensions)packetListener;
            extension.getAddon().handleDisconnect();
        }
        if ((packetListener = this.packetListener) instanceof NeoListenableNetworkHandler) {
            NeoListenableNetworkHandler handler = (NeoListenableNetworkHandler)packetListener;
            handler.handleDisconnect();
        }
    }
}

